--[[function genMBInfo()
	return {Character="None",Difficulty=1}
end;]]


local MBAAClass = {}
MBAAClass.__index = MBAAClass

--Add functions to the class
-- "function MBAAClass.new(init)" also works
MBAAClass.new = function()
	--Magic function that turns a table into a class thing
	local self = setmetatable({}, MBAAClass)
	--Wow it's just like JavaScript
	self.info = {{Character="None",Difficulty=1},{Character="None",Difficulty=1}};
	Warn("MBSTATE initialized.")
	--assert(self.info, "WTF?")
	return self;
end;
MBAAClass.GetCharacter = function(self, pn)
	--[[assert(pn, "No player?")
	assert(self.info[1], "P2 slot doesn't exist!")
	assert(self.info[1].Character, "Character slot missing from table!");
	SCREENMAN:SystemMessage(PlayerNumber:Reverse()[pn]+1);]]
	
	--Uncomment to enable setting by int instead of PlayerNumber
	--if type(pn) == "string" then
		return self.info[PlayerNumber:Reverse()[pn]+1].Character;
	--else
	--	return self.info[pn+1].Character;
	--end;
	
	--return "Error";
end;
MBAAClass.SetCharacter = function(self, pn, ch)
	--Uncomment to enable setting by int instead of PlayerNumber
	--if type(pn) == "string" then
		self.info[PlayerNumber:Reverse()[pn]+1].Character = ch
	--else
	--	self.info[pn+1].Character
	--end;
end;


MBAAClass.SetRandomEncounterList = function(self,list)
	self.encounterList = list;
	assert(self.encounterList)
end;

MBAAClass.GetRandomEncounter = function(self)
	assert(self.encounterList, "The random encounter list is empty.")
	local pick = math.random(#self.encounterList);
	--SCREENMAN:SystemMessage("Picked "..self.encounterList[pick].." ("..pick..")");
	return self.encounterList[pick];
	--[[local characters = {
		"Aozaki",
		"ArimaMiyako",
		"HisuiAndKohaku",
		"SchoolAkiha",
		"TohnoShiki",
		"Ciel",
		"TohnoAkiha",
		"Satsuki",
		"KohaAndMech",
		"ArchetypeEarth",
		"SionEltnam",
		"Arcueid",
		"Len",
		"Hisui",
		"NanayaShiki",
		"Riesbyfe",
		"PoweredCiel",
		"RyougiShiki",
		"NekoArcN",
		"KishimaKouma",
		"SionTatari",
		"RedArcueid",
		"WhiteLen",
		"Kohaku",
		"Wallachia",
		"AkihaVermillion",
		"Chaos",
		"NekoAndMech",
		"MichaelRoa",
		"MechHisui",
		"NekoArcChaos"
	};]]
end;

MBAAClass.SetEnemyCharacter = function(self, ch)
	assert(GAMESTATE:GetNumSidesJoined() == 1,"Can't set the enemy character when there are two players present!");
	local master = PlayerNumber:Reverse()[GAMESTATE:GetMasterPlayerNumber()]+1
	local opposite = 1
	if master == 1 then
		opposite = 2;
	end;
	self.info[opposite].Character = ch;
	assert(self.info[master].Character ~= "None", "Player Character (P"..master..") not set!")
	assert(self.info[opposite].Character ~= "None", "Opponent Character (P"..opposite..") not set!")
end;

MBAAClass.GetDifficulty = function(self, pn)
	return self.info[PlayerNumber:Reverse()[pn]+1].Difficulty;
end;
MBAAClass.SetDifficulty = function(self, pn, diff)
	self.info[PlayerNumber:Reverse()[pn]+1].Difficulty = diff;
end;

MBAAClass.Reset = function(self)
	self.info = {{Character="None",Difficulty=1},{Character="None",Difficulty=1}};
	self.encounterList = nil;
	Warn("MBSTATE initialized.")
end;

-- Make an instance of the class
MBSTATE = MBAAClass.new();